package gov.va.med.domain.service.messaging.parse;

import gov.va.med.domain.model.validation.IValidationError;
import ca.uhn.hl7v2.model.Structure;

/**
 * Holds common values for parsing errors.
 * 
 * Normally the Exception is an HL7Exception (if it occurred during parsing)
 * but an error can be sensed by decoders for values that HAPI allowed
 * but the Decoder failed to convert to expected data type (Date, BigDecimal etc..).    
 * @author Joel Goldberg
 * @version $Id: HL7ParseError.java,v 1.4 2005/07/28 15:21:46 joel.goldberg Exp $
 * @since MHV 2.0 <br>Jun 15, 2005
 */
public class HL7ParseError implements IValidationError {
	private String icn;
    private Structure structure;
    private Exception exception;
    
    public HL7ParseError() {
        super(); 
    }
    
    public Structure getStructure() { return structure; }
    public Exception getException() {return exception; }
    public void setStructure(Structure structure){ this.structure = structure;}
    public void setException(Exception exception) {this.exception = exception; }
    public String getIcn() {return icn;}
    public void setIcn(String icn) {this.icn = icn;}

    public String getErrorDescrpition() {
        return "HL7 Parse error for [" + 
        		getFieldName() +
        		"] with exception: " + getException().getLocalizedMessage() ;
    }

    public String getErrorKey() {
        return getException().getClass().getName();
    }

    public String getFieldName() {
        return getStructure().getName();
    }

}
